<?php
function getFaviconUrl($pdo) {
    $stmt = $pdo->prepare("SELECT setting_value, setting_binary FROM store_settings WHERE setting_key = 'favicon' AND setting_group = 'store_info'");
    $stmt->execute();
    $favicon = $stmt->fetch();
    if ($favicon && $favicon['setting_binary']) {
        $mimeType = 'image/x-icon'; // Default to ICO
        if (strpos($favicon['setting_value'], '.png') !== false) {
            $mimeType = 'image/png';
        }
        return 'data:' . $mimeType . ';base64,' . base64_encode($favicon['setting_binary']);
    }
    return null;
}

function getFaviconLink($pdo) {
    $faviconUrl = getFaviconUrl($pdo);
    if ($faviconUrl) {
        return '<link rel="icon" type="image/x-icon" href="' . $faviconUrl . '">';
    }
    return '<link rel="icon" type="image/x-icon" href="../assets/images/favicon.ico">';
}
?> 